clear
close all
clc
line_plot = 0;
plot_non_final = 1;
delta_max = 7;
%% File reading
fid = fopen('Spiral_32Measurements.txt');
    formatSpec = '%s';
    N = 32*4;
    C_text = textscan(fid,formatSpec,N,'Delimiter','\t');
    C_data0 = textscan(fid,repmat('%f',[1,32*4]),'Delimiter','\t');
fclose(fid);

%% Data processing
index_vec = 1:128;index_vec(1:4:end)=[];index_vec(3:3:end)=[];
Mat_data = [(1:3600)' cell2mat(C_data0(index_vec))]; % N(solo la col 1) Angolo(deg) Valore
% Mat_data = Mat_data(1:5:end,:);

nMeasurements = 32;
r0 = 16; % [mm]
rf = 33; % [mm]
deltaR = (rf-r0)/nMeasurements;

nPoints = size(Mat_data,1); % Data points per radius
r_vec = zeros(nPoints*nMeasurements,1);
r_mat = zeros(nPoints,nMeasurements);
z_vec = r_vec;
z_mat = r_mat;
theta_vec = repmat(Mat_data(:,2),nMeasurements,1)*pi/180;
theta_mat = repmat(Mat_data(:,2),1,nMeasurements)*pi/180;

% if line_plot
%     figure
%     hold on
% end
for i =1:nMeasurements
    r_vec((1:nPoints)+nPoints*(i-1)) = r0+deltaR*(i-1);
    r_mat(:,i) = r0+deltaR*(i-1);
    z_vec((1:nPoints)+nPoints*(i-1)) = Mat_data(:,3+2*(i-1));
    z_mat(:,i) = Mat_data(:,3+2*(i-1));
    X = r_vec(1+nPoints*(i-1))*cos(theta_vec(1:nPoints));
    Y = r_vec(1+nPoints*(i-1))*sin(theta_vec(1:nPoints));
    % if line_plot
    % plot3(X,Y,z_vec((1:nPoints)+nPoints*(i-1)),'b')
    % end

end
% axis equal
% hold off

%% Plots
X = r_mat.*cos(theta_mat);
Y = r_mat.*sin(theta_mat);

X_ring = X(:,1:8);
Y_ring = Y(:,1:8);
Z_ring = z_mat(:,1:8);

B_mine = [reshape(X(:,1:8),[],1), reshape(Y(:,1:8),[],1), ones(nPoints*8,1)]\reshape(z_mat(:,1:8),[],1);
B_full = [reshape(X,[],1), reshape(Y,[],1), ones(numel(X),1)]\reshape(z_mat,[],1);
[fitresult, ~] = createFit(X_ring, Y_ring, Z_ring);

B = [fitresult.p10 fitresult.p01 fitresult.p00];

xv = [min(reshape(X(:,1:8),[],1)) max(reshape(X(:,1:8),[],1))];
% xv = [min(reshape(X,[],1)) max(reshape(X,[],1))];

x_vec = [min(xv) min(xv) max(xv) max(xv)];
X_vec = [min(min(X)) min(min(X)) max(max(X)) max(max(X))];

yv = [min(reshape(Y(:,1:8),[],1)) max(reshape(Y(:,1:8),[],1))];
% yv = [min(reshape(Y,[],1)) max(reshape(Y,[],1))];

y_vec = [min(yv) max(yv) max(yv) min(yv)];
Y_vec = [min(min(Y)) max(max(Y)) max(max(Y)) min(min(Y))];

% zv = [xv(:), yv(:), ones(2,1)] * B;
fit_plane_func = @(x,y) B(1).*x+B(2).*y + B(3);

if plot_non_final
figure
hold on
mesh(X,Y,z_mat);
% patch([min(xv) min(xv) max(xv) max(xv)], [min(yv) max(yv) max(yv) min(yv)], [min(zv) min(zv) max(zv) max(zv)], 'r', 'FaceAlpha',0.5)
patch(x_vec,y_vec,fit_plane_func(x_vec,y_vec),'r', 'FaceAlpha',0.5)
% patch(X_vec,Y_vec,fit_plane_func(X_vec,Y_vec),'r', 'FaceAlpha',0.5)
hold off
colorbar
xlabel('x')
ylabel('y')
view(2)
axis equal
title('Raw data')
end


pivot = [max(X_vec) max(Y_vec)];pivot = [pivot fit_plane_func(pivot(1),pivot(2))];
delta_z = pivot(3) - fit_plane_func(X,Y);
B = [reshape(X,[],1), reshape(Y,[],1), ones(numel(X),1)]\reshape(z_mat+delta_z,[],1);
z_mat_flat = z_mat+delta_z; %-pivot(3) + mean(z_mat(:,1:8),"all")

if plot_non_final
figure
mesh(X,Y,z_mat_flat);
colorbar
xlabel('x')
ylabel('y')
title('Non-filtered, flat')
axis equal
view(2)
end
z_mat_flat = Data_filtering(z_mat_flat,delta_max);
% z_outlier = isoutlier(z_mat);

figure
mesh(X,Y,z_mat_flat);
axis equal
colorbar
axis equal
xlabel('x')
ylabel('y')
title('Filtered, flat')
view(2)

%% Groove Identification
R_G = 20;
R0 = rf-0.5;
p1 = [19.4856 0.748562];
p2 = [18.1556 7.1151];
p3 = [16.5189 10.3623];

alpha1 =atan(norm(p1-p2)/norm(p1));
a1 = rf*alpha1;
% a1 = norm(p1-p2);
p4 = [12.1397 26.8864];
p5 = [16.4962 24.4556];
alpha2 =atan(norm(p4-p5)/norm(p4));
a2 = rf*alpha2;
target_sum = deg2rad(30)*rf;
actual_sum = a1+a2;
delta_sum = target_sum-actual_sum;
x = (2/3*target_sum-a1)/delta_sum;
a1 = a1+x*delta_sum;
a2 = a2 + (1-x)*delta_sum;
% a2 = a2+0.5
alpha_b = atan(norm(p2-p3)/norm(p2));
% b = R_G*alpha_b;
b = 6;
% b = norm(p2-p3);
beta = -70; %beta = deg2rad(beta);
n_grooves = 12;

acc = 0.5;
a1 = round(a1/acc)*acc;
a2 = round(a2/acc)*acc;
Y_spiral = (R0-R_G)/(R0-r0);
X_spiral = a1/a2;
% [ang,ang1] = f_plotto_spiral(r0,R0,X_spiral,Y_spiral,n_grooves,beta);
delta_ang = 20.5; %[deg]
delta_ang = delta_ang*pi/180;

[ang,ang1,isGroove] = GetGrooves(r0,R0,X_spiral,Y_spiral,n_grooves,beta,delta_ang,r_mat,theta_mat);
writematrix(isGroove,'isGroove.txt','Delimiter','tab')

% isGroove = z_mat_flat<0;
x_Non_groove = X(~isGroove);
y_Non_groove = Y(~isGroove);
z_Non_groove = z_mat_flat(~isGroove);

[xData, yData, zData] = prepareSurfaceData( x_Non_groove, y_Non_groove, z_Non_groove );
ft = fittype( 'poly22' );
opts = fitoptions( 'Method', 'LinearLeastSquares' );
opts.Robust = 'Bisquare';
[fitresult, gof] = fit( [xData, yData], zData, ft, opts );
func_surf_fit = @(x,y) fitresult.p00 + fitresult.p10*x + fitresult.p01*y + fitresult.p20*x.^2 + fitresult.p11*x.*y + fitresult.p02*y.^2;
z_ref = mean(z_mat_flat(:,1:8),"all");

delta_z = z_ref - func_surf_fit(X,Y);
z_mat_flat = z_mat_flat + delta_z;%- mean(z_Non_groove,"all");
z_mat_flat = z_mat_flat - mean(z_mat_flat(~isGroove),"all");
writematrix(z_mat_flat,'z_mat_flat.txt','Delimiter','tab')
z_groove = z_mat_flat(isGroove);
fprintf('Mean Groove value = %.2f \n',mean(z_groove))
% Z_groove = z_mat_flat;Z_groove(Z_groove>0) = NaN;
% Z_non_groove = z_mat_flat;Z_non_groove(Z_non_groove<0)=NaN;
Z_groove = z_mat_flat;Z_groove(~isGroove) = NaN;
Z_non_groove = z_mat_flat;Z_non_groove(isGroove)=NaN;

% figure
% mesh(X,Y,z_mat_flat);
% axis equal
% colorbar
% axis equal
% xlabel('x')
% ylabel('y')
% title('Filtered, Plane and Surface fit')
% view(2)

figure
subplot(1,2,1)
mesh(X,Y,Z_groove);
colorbar
axis equal
title('Groove profile and depth')
xlabel('x')
ylabel('y')
view(2)

subplot(1,2,2)
mesh(X,Y,Z_non_groove);
colorbar
axis equal
title('Non-Grooved profile and height')
xlabel('x')
ylabel('y')
view(2)

[X_in,Y_in] = pol2cart(linspace(0,2*pi,100)',ones(100,1)*r0);
[X_out,Y_out] = pol2cart(linspace(0,2*pi,100)',ones(100,1)*R0);
[X_ang,Y_ang] = pol2cart(ang,repmat(linspace(R_G,R0)',1,size(ang,2)));
[X_ang1,Y_ang1] = pol2cart(ang1,repmat(linspace(R_G,R0)',1,size(ang1,2)));

figure
% mesh(X,Y,z_mat_flat-max(z_mat_flat,[],"all"),'EdgeColor','interp');
mesh(X,Y,z_mat_flat,'EdgeColor','interp');
axis equal
colorbar
axis equal
xlabel('x')
ylabel('y')
% title('Filtered, Plane and Surface fit')
title('Surface Scan of Grooves Bearing')
view(2)

hold on
plot(X_in,Y_in,'b','LineWidth',1.5)
plot(X_out,Y_out,'b','LineWidth',1.5)
plot(X_ang,Y_ang,'b','LineWidth',1.5)
plot(X_ang1,Y_ang1,'b','LineWidth',1.5)
for i = 1:n_grooves
    b_ang = linspace(ang(1,i),ang1(1,i),10)';
    [X_b,Y_b] = pol2cart(b_ang,R_G*ones(10,1));
    plot(X_b,Y_b,'b','LineWidth',1.5)
end
hold off

section_theta = (a1+a2)/rf*180/pi;

% [X_in,Y_in] = pol2cart(linspace(-pi/2,pi/2,100)',ones(100,1)*r0);
% [X_out,Y_out] = pol2cart(linspace(-pi/2,pi/2,100)',ones(100,1)*R0);
% [X_ang,Y_ang] = pol2cart(ang(:,[1 2]),repmat(linspace(R_G,R0)',1,size(ang(:,[1 2]),2)));
% [X_ang1,Y_ang1] = pol2cart(ang1,repmat(linspace(R_G,R0)',1,size(ang1,2)));

%% Plot diagram
% Y_spiral = (R0-0.64*R0)/(R0-r0);
% X_spiral = 0.64;
% beta = -72.61;
% deta_ang = 0;
% [ang,ang1,~] = GetGrooves(r0,R0,X_spiral,Y_spiral,n_grooves,beta,delta_ang,r_mat,theta_mat);
% [X_in,Y_in] = pol2cart(linspace(0,2*pi,100)',ones(100,1)*r0);
% [X_out,Y_out] = pol2cart(linspace(0,2*pi,100)',ones(100,1)*R0);
% [X_ang,Y_ang] = pol2cart(ang,repmat(linspace(R_G,R0)',1,size(ang,2)));
% [X_ang1,Y_ang1] = pol2cart(ang1,repmat(linspace(R_G,R0)',1,size(ang1,2)));

figure
hold on
plot(X_in,Y_in,'k','LineWidth',1.5)
plot(X_out,Y_out,'k','LineWidth',1.5)
plot(X_ang,Y_ang,'k','LineWidth',1.5)
plot(X_ang1,Y_ang1,'k','LineWidth',1.5)
c = [120 120 120]/255;
for i = 1:n_grooves
    b_ang = linspace(ang(1,i),ang1(1,i),10)';
    [X_b,Y_b] = pol2cart(b_ang,R_G*ones(10,1));
    plot(X_b,Y_b,'k','LineWidth',1.5)
    [x_ang,y_ang] = pol2cart(ang(:,i),repmat(linspace(R_G,R0)',1,size(ang(:,i),2)));
    [x_ang1,y_ang1] = pol2cart(ang1(:,i),repmat(linspace(R_G,R0)',1,size(ang1(:,i),2)));
    [aux_xi,aux_yi] = pol2cart((ang(end,i)+ang1(end,i))/2,R0);
    [aux_xo,aux_yo] = pol2cart((ang(1,i)+ang1(1,i))/2,R_G);
    x_a = [x_ang1' aux_xi fliplr(x_ang') aux_xo];
    inBetween = [y_ang1' aux_yi fliplr(y_ang') aux_yo];
    fill(x_a,inBetween,c)
end
hold off
axis equal
axis padded

%% Partial plot
ploted_grooves = 3;
theta_end = pi/3;
[ang,ang1,isGroove] = GetGrooves(r0,R0,X_spiral,Y_spiral,n_grooves,-beta,delta_ang,r_mat,theta_mat);
ang = ang(:,1:ploted_grooves);
ang1 = ang1(:,1:ploted_grooves);
[X_in,Y_in] = pol2cart(linspace(pi/6,2*theta_end,100)',ones(100,1)*r0);
[X_b,Y_b] = pol2cart(linspace(pi/6,2.2*theta_end,100)',ones(100,1)*R_G);
[X_out,Y_out] = pol2cart(linspace(-pi/6,1.2*theta_end,100)',ones(100,1)*R0);
[X_ang,Y_ang] = pol2cart(ang,repmat(linspace(R_G,R0)',1,size(ang,2)));
[X_ang1,Y_ang1] = pol2cart(ang1,repmat(linspace(R_G,R0)',1,size(ang1,2)));

figure
hold on
plot(0,0,".k",'MarkerSize',15)
plot(X_in,Y_in,'--k','LineWidth',0.75)
plot(X_b,Y_b,'--k','LineWidth',0.75)
plot(X_out,Y_out,'--k','LineWidth',0.75)
plot(X_ang,Y_ang,'k','LineWidth',1.5)
plot(X_ang1,Y_ang1,'k','LineWidth',1.5)

for i = 1:ploted_grooves
    b_ang = linspace(ang(1,i),ang1(1,i),10)';
    [X_b,Y_b] = pol2cart(b_ang,R_G*ones(10,1));
    plot(X_b,Y_b,'k','LineWidth',1.5)
    [x_ang,y_ang] = pol2cart(ang(:,i),repmat(linspace(R_G,R0)',1,size(ang(:,i),2)));
    [x_ang1,y_ang1] = pol2cart(ang1(:,i),repmat(linspace(R_G,R0)',1,size(ang1(:,i),2)));
    [aux_xi,aux_yi] = pol2cart((ang(end,i)+ang1(end,i))/2,R0);
    [aux_xo,aux_yo] = pol2cart((ang(1,i)+ang1(1,i))/2,R_G);
    x_a = [x_ang1' aux_xi fliplr(x_ang') aux_xo];
    inBetween = [y_ang1' aux_yi fliplr(y_ang') aux_yo];
    fill(x_a,inBetween,c)
end

hold off
axis equal
axis padded

% c = [120 120 120]/255;
% for i = 1:n_grooves
%     b_ang = linspace(ang(1,i),ang1(1,i),10)';
%     [X_b,Y_b] = pol2cart(b_ang,R_G*ones(10,1));
%     plot(X_b,Y_b,'k','LineWidth',1.5)
%     [x_ang,y_ang] = pol2cart(ang(:,i),repmat(linspace(R_G,R0)',1,size(ang(:,i),2)));
%     [x_ang1,y_ang1] = pol2cart(ang1(:,i),repmat(linspace(R_G,R0)',1,size(ang1(:,i),2)));
%     [aux_xi,aux_yi] = pol2cart((ang(end,i)+ang1(end,i))/2,R0);
%     [aux_xo,aux_yo] = pol2cart((ang(1,i)+ang1(1,i))/2,R_G);
%     x_a = [x_ang1' aux_xi fliplr(x_ang') aux_xo];
%     inBetween = [y_ang1' aux_yi fliplr(y_ang') aux_yo];
%     fill(x_a,inBetween,c)
% end
% hold off
% axis equal
% axis padded


% section_theta = 30;
% n_rows = section_theta*10;
% figure
% mesh(X(1:n_rows,:),Y(1:n_rows,:),z_mat_flat(1:n_rows,:))
% view(2)

% v1 = [27.09 15.07];
% v2 = [31 0]';
% alpha = acos((v1*v2)/(norm(v1)*norm(v2)))*180/pi